/*
	$DOCFILE:IOCTL.C

	Copyright (C) 2000 Datalight, Inc.
	All Rights Reserved

	Diagnostic testing Sockets/DOS IOCTL functions using CAPI

	$DOCHISTORY:
	1.00 2000-05-24 First release
	1.01 2000-06-13 Changes in Sockets version 2.06
   1.02 2000-12-19 Added Shell command
	1.03 2001-02-02 Optionally specify interface name on command line

	Compile and link with CAPI.C
	Use TABS=3 spaces for properly formatted source

	IOCTL currently only functions with SOCKETM on Async ports
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include <stdarg.h>
#include <time.h>
#include <dos.h>
#include <ctype.h>
#include "capi.h"

char *GetErrorString(unsigned uErrCode);
char *IPAddressString(DWORD dwIPAddress);
void GetPingDestination(void);
DWORD dwIPAddress;	// ping destination
char szHelp[] =
	"Commands: (c)onnect, (d)rop, (n)o demand dial, demand dial (o)n\n"
	"          (e)nable port, d(i)sable port, (p)ing (a)ddress, (s)hell, e(x)it\n";

char *pszModemStates[] = {
	"No modem",
	"Modem idle",
	"Modem init'ing",
	"Modem dialing",
	"Modem connecting",
	"Modem answering"
};

char *pszPPPStates[] = {
	"PPP dead",
	"LCP phase",
	"AP phase",
	"PPP Ready",
	"Terminating"
};

int main(int argc, char *argv[])
{
	WORD wLen;
	char szNameBuf[80];
	char *rgszArgs[2];		//used in executing COMSPEC
	int iStat,iStatOld = -1,iVersion;
	char cKey;

	wLen = sizeof(szNameBuf);
	szNameBuf[0] = 0;
	if (GetKernelInformation(0, K_INF_HOSTNAME, 0, szNameBuf, &wLen) < 0)
	{
		printf("Error %u: %s\n",iNetErrNo,GetErrorString(iNetErrNo));
		exit(1);
	}
	if ((iVersion = GetSocketsVersion()) < 0)
	{
		printf("IOCTL not supported by this Sockets version\n");
		exit(1);
	}
	printf("IOCTL diagnostic 1.03 on '%s' Sockets version %u.%02u\n%s\n",
			szNameBuf,iVersion >> 8, iVersion & 0xff,szHelp);
	if (iVersion < 2 * 256 + 6)
	{
		printf("This version of IOCTL requires Sockets version 2.06 or higher\n");
		exit(1);
	}
	if (argc > 1)
		strcpy(szNameBuf,argv[1]);
	else
		*szNameBuf = 0;
	while (IfaceIOCTL(szNameBuf,IOCTL_GETSTATUS) < 0)
	{
		if (iNetErrNo == ERR_BAD_SYS_CALL)
		{
			printf("This version of Sockets does not support IOCTL\n");
			exit(1);
		}
		printf("Interface '%s' not found\n"
				"Please enter the name of the interface: ",szNameBuf);
		gets(szNameBuf);
		if (*szNameBuf == 0)
			exit(1);
	}
	while (1) {
		if (kbhit())
		{
			cKey = getch();
			switch(cKey)
			{
			case 'a':
				GetPingDestination();
				break;
			case 'c':
				printf("Connect\n");
				if (IfaceIOCTL(szNameBuf,IOCTL_CONNECT) < 0)
					printf("Error %u: %s\n",iNetErrNo,GetErrorString(iNetErrNo));
				break;
			case 'd':
				printf("Drop\n");
				if (IfaceIOCTL(szNameBuf,IOCTL_DISCONNECT) < 0)
					printf("Error: %u %s\n",iNetErrNo,GetErrorString(iNetErrNo));
				break;
			case 'n':
				printf("No demand dial\n");
				if (IfaceIOCTL(szNameBuf,IOCTL_DISABLEDOD) < 0)
					printf("Error: %u %s\n",iNetErrNo,GetErrorString(iNetErrNo));
				break;
			case 'o':
				printf("Demand dial on\n");
				if (IfaceIOCTL(szNameBuf,IOCTL_ENABLEDOD) < 0)
					printf("Error: %u %s\n",iNetErrNo,GetErrorString(iNetErrNo));
				break;
			case 'e':
				printf("Enable port\n");
				if (IfaceIOCTL(szNameBuf,IOCTL_ENABLEPORT) < 0)
					printf("Error: %u %s\n",iNetErrNo,GetErrorString(iNetErrNo));
				break;
			case 'i':
				printf("Disable port\n");
				if (IfaceIOCTL(szNameBuf,IOCTL_DISABLEPORT) < 0)
					printf("Error: %u %s\n",iNetErrNo,GetErrorString(iNetErrNo));
				break;
			case 'p':
				while (!dwIPAddress)
					GetPingDestination();
				printf("Pinging %s ... ",IPAddressString(dwIPAddress));
				if (ICMPPing(dwIPAddress,10) < 0)
					printf("failed\n");
				else
					printf("success\n");
				break;
			case 's':		// shell
				if ((rgszArgs[0] = getenv("COMSPEC")) == 0)
					rgszArgs[0] = "\\COMMAND.COM";
				rgszArgs[1] = 0;
				spawnvp(P_WAIT, rgszArgs[0], rgszArgs);
				break;
			case 'x':
				printf("Exit\n");
				goto done;
			default:
				printf(szHelp);
				break;
			}
		}
		if ((iStat = IfaceIOCTL(szNameBuf,IOCTL_GETSTATUS)) < 0)
			printf("Error: %u %s\n",iNetErrNo,GetErrorString(iNetErrNo));
		if (iStat != iStatOld) {
			printf("Status: %s %s %s %s %s %s %s %s %s %s\n",
				iStat & ST_DTR ? "DTR" : "   ",
				iStat & ST_RTS ? "RTS" : "   ",
				iStat & ST_CTS ? "CTS" : "   ",
				iStat & ST_DSR ? "DSR" : "   ",
				iStat & ST_RI  ? "RI"  : "  ",
				iStat & ST_DCD ? "DCD" : "   ",
				iStat & ST_CONNECTED ? "Connected" : "Unconnected",
				pszModemStates[(iStat & ST_MODEMSTATE) >> 8],
				pszPPPStates[(iStat & STPPP_STATE) >> 12],
				iStat & STPPPP_IN ? "Incoming" : "Outgoing");
			iStatOld = iStat;
		}
	}
	done:
	return 0;
}

/*
Create a human understandable string from a Sockets error code.

Argument:
	uErrCode - The sockets error code.

Returns:
	A pointer to the (static) string representation of the error.
*/
char *GetErrorString(unsigned uErrCode)
{
	static char rgcUnk[30];
	static char *rgszErrs[] =
	{
		"NO_ERR",					// 0	// No error
		"ERR_IN_USE",				// 1	// A connection already exists
		"ERR_DOS",					// 2	// A DOS error occured
		"ERR_NO_MEM",				// 3	// No memory to perform function
		"ERR_NOT_NET_CONN",		// 4	// Connection does not exist
		"ERR_ILLEGAL_OP",			// 5	// Protocol or mode not supported
		"ERR_BAD_PACKET",
		"ERR_NO_HOST",				// 7	// No host address specified
		"ERR_CANT_OPEN",
		"ERR_NET_UNREACHABLE",
		"ERR_HOST_UNREACHABLE",
		"ERR_PROTOCOL_UNREACHABLE",
		"ERR_PORT_UNREACHABLE",
		"ERR_TIMEOUT",				// 13	// The function timed out
		"ERR_HOST_UNKNOWN",		// 14	// Unknown host has been specified
		"ERR_NO_SERVERS",
		"ERR_SERVER_ERR",
		"ERR_BAD_FORMAT",
		"ERR_BAD_ARG",				// 18	// Bad arguments
		"ERR_EOF",					// 19	// The connection has been closed by peer
		"ERR_RESET",				// 20	// The connection has been reset by peer
		"ERR_WOULD_BLOCK",		// 21	// Operation would block
		"ERR_UNBOUND",				// 22	// The descriptor has not been assigned yet
		"ERR_NO_SOCKET",			// 23	// No descriptor is available
		"ERR_BAD_SYS_CALL",		// 24	// Bad parameter in call
		"ERR_CANT_BROADCAST",
		"ERR_NOT_ESTAB",			// 26	// The connection has not been established
		"ERR_RE_ENTRY",			// 27	// The kernel is in use, try again later
	};

	if (uErrCode == ERR_API_NOT_LOADED)
		return "Sockets API not loaded";
	if ((uErrCode & 0xff) > ERR_RE_ENTRY)
	{
		sprintf(rgcUnk, "Unknown error 0x%04X", uErrCode);
		return rgcUnk;
	}
	return rgszErrs[uErrCode & 0xff];
}

char *IPAddressString(DWORD dwIPAddress)
{
	static char sz[20];

	sprintf(sz, "%u.%u.%u.%u",
			((BYTE *)&dwIPAddress)[0],((BYTE *)&dwIPAddress)[1],
			((BYTE *)&dwIPAddress)[2],((BYTE *)&dwIPAddress)[3]);
	return sz;
}

void GetPingDestination(void)
{
	char szNameBuf[80];
	char sz[80];

	while (1)
	{
		printf("Please enter ping destination eg 10.0.1.2: ");
		gets(sz);
		if ((dwIPAddress = ResolveName(sz, szNameBuf, sizeof(szNameBuf))) != 0)
			return;
		printf("Invalid address!\n");
	}
}
